// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef CONTAINER_H
#define CONTAINER_H

#include "degub.h"
#include <malloc.h>

template<class T> class SubContainer;

template<class T> class Container {
public:
	Container(size_t size) {
		b = 0;
		allocate(size);
		g_con_num++;
		if(g_con_num > g_con_num_max)
			g_con_num_max = g_con_num;
	}
	Container(size_t size, const T *data) {
		b = 0;
		allocate(size);
		memcpy(a, data, size);
		g_con_num++;
		if(g_con_num > g_con_num_max)
			g_con_num_max = g_con_num;
	}
	~Container() {
		if(a) /*if(_msize(a))*/ free(a);
		g_con_total -= b;
		g_con_num--;
	}
	void resize(size_t size) {
		if(b == size)
			return;
		free(a);
		allocate(size);
	}

	/*void insert(int before, void *src, size_t size) {
	char *temp = a;
	a = new char[b + size];
	if(a == NULL)
	BFE("Memory insert failed in container");
	memcpy(a, temp, before);
	memcpy(a+before, src, size);
	memcpy(a+before+size, temp+before, b-before);
	b += size;
	delete temp;
	}*/

	class SubContainer : public Container {
	private:
		SubContainer(void* ptr, size_t size) : Container(ptr, size) {}
		friend class Container;
	public:
		~SubContainer() {
			a = NULL;
			b = 0;
			g_con_num++;  //to offset Container's destructor
		}
	};
	SubContainer getSub(size_t pos) {
		return SubContainer(((char*)a) + pos, b - pos);
	}

	operator T*() { return (T *)a; }
	operator const T*() const { return (T *)a; }
	T* p() { return (T *)a; }
	const T* p() const { return (T *)a; }
	T *operator->() { return (T *)a; }
	size_t size() const { return b; }
	void steal(Container<T> &src) {
		resize(0); a = src.a; b = src.b;
		src.a = NULL; src.b = 0;
	}
	void swap(Container<T> &other) {
		T *ta = a; size_t tb = b;
		a = other.a; b = other.b;
		other.a = ta; other.b = tb;
	}
protected:
	void *a;
	size_t b;
private:
	Container(const Container&);
	Container &operator=(const Container&);
	Container(void* ptr, size_t size) : a(ptr), b(size) {}
	friend class SubContainer;

	void allocate(size_t size) {
		if(size > 100*M)
			throw generic_fatal_exception("Container size: " + size);

		g_con_total += size-b;
		//DEGUB("Resize: %i -> %i = %i\n", b, size, g_con_total);
		if(g_con_total > g_con_maximum)
			g_con_maximum = g_con_total;
		//if(size > 1000*K) {
		//DEGUB("Megabyte Container resize!\n");
		//}

		b = size;
		if(size == 0)
			a = NULL;
		else {
			a = malloc(size);
			if(!_CrtIsValidHeapPointer(a))
				throw generic_fatal_exception("malloc failed in Container");
		}
	}
};

#endif	//CONTAINER_H
